/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api;

import filenet.vw.base.logging.Logger;
import filenet.ws.api.WSParam;
import filenet.ws.api.WSParamArray;
import filenet.ws.api.WSTemplateBase;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSParamParent
extends WSParam {
    protected static Logger logger = Logger.getLogger("filenet.ws.api");
    private static String m_className = "WSParamParent";
    protected Vector m_children = null;

    public static String _get_FILE_DATE() {
        return "$Date:   10 Sep 2008 10:03:48  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.12  $";
    }

    public void releaseReferences() {
        block4: {
            try {
                if (this.m_children != null) {
                    WSParam param = null;
                    Vector children = this.m_children;
                    this.m_children = null;
                    for (int i = children.size() - 1; i >= 0; --i) {
                        param = (WSParam)children.remove(i);
                        if (param == null) continue;
                        param.releaseReferences();
                    }
                    param = null;
                    Object var2_3 = null;
                }
                super.releaseReferences();
            }
            catch (Exception ex) {
                if (!logger.isFinest()) break block4;
                logger.throwing(m_className, "releaseReferences", ex);
            }
        }
    }

    public WSParamParent(WSParamParent parent) {
        this.m_parent = parent;
    }

    public WSParamParent(WSParamParent parent, String name, String namespace, String typeNSPrefix, String typeName) {
        super(parent, name, namespace, typeNSPrefix, typeName);
        this.m_bBaseType = false;
    }

    public void addChild(WSParam param) {
        if (this.m_children == null) {
            this.m_children = new Vector();
        }
        this.m_children.add(param);
    }

    public void addChild(Vector params) {
        if (params != null && params.size() > 0) {
            if (this.m_children == null) {
                this.m_children = new Vector();
            }
            for (int i = 0; i < params.size(); ++i) {
                if (params.get(i) == null || !(params.get(i) instanceof WSParam)) continue;
                this.m_children.add((WSParam)params.get(i));
            }
        }
    }

    public WSParam[] getChildren() {
        if (this.m_children != null && this.m_children.size() > 0) {
            WSParam[] children = new WSParam[this.m_children.size()];
            this.m_children.toArray(children);
            return children;
        }
        return null;
    }

    public boolean isArrayParent() {
        if (this.m_children != null && this.m_children.size() > 0) {
            Object obj = null;
            for (int i = 0; i < this.m_children.size(); ++i) {
                obj = this.m_children.elementAt(i);
                if (obj == null || !(obj instanceof WSParamArray)) continue;
                return true;
            }
        }
        return false;
    }

    public String toXML() {
        String s = new String();
        s = s + "<" + this.getName();
        s = this.m_parent != null && this.m_parent.isSameNamespace(this.m_namespace) ? s + ">\n" : s + " xmlns='" + this.getNamespace() + "'>\n";
        if (this.m_children != null && this.m_children.size() > 0) {
            Object obj = null;
            for (int i = 0; i < this.m_children.size(); ++i) {
                obj = this.m_children.get(i);
                if (obj == null || !(obj instanceof WSParam)) continue;
                s = s + ((WSParam)obj).toXML();
            }
        }
        s = s + "</" + this.getName() + ">\n";
        return s;
    }

    public String toXMLTemplate() {
        String s = new String();
        s = s + "<" + this.getName();
        s = this.m_parent != null && this.m_parent.isSameNamespace(this.m_namespace) ? s + ">\n" : s + " xmlns='" + this.getNamespace() + "'>\n";
        if (this.m_children != null && this.m_children.size() > 0) {
            Object obj = null;
            for (int i = 0; i < this.m_children.size(); ++i) {
                obj = this.m_children.get(i);
                if (obj == null || !(obj instanceof WSParam)) continue;
                s = s + ((WSParam)obj).toXMLTemplate();
            }
        }
        s = s + "</" + this.getName() + ">\n";
        return s;
    }

    protected Element createElement(Document doc, int bindingStyle) {
        Element element = super.createElement(doc, bindingStyle);
        if (this.m_children != null && this.m_children.size() > 0) {
            Object obj = null;
            for (int i = 0; i < this.m_children.size(); ++i) {
                obj = this.m_children.get(i);
                if (obj == null || !(obj instanceof WSParam)) continue;
                if (obj instanceof WSParamArray) {
                    Element[] elements = ((WSParamArray)obj).createElements(doc, bindingStyle);
                    if (elements == null || elements.length <= 0) continue;
                    for (int j = 0; j < elements.length; ++j) {
                        element.appendChild(elements[j]);
                    }
                    continue;
                }
                element.appendChild(((WSParam)obj).createElement(doc, bindingStyle));
            }
        }
        return element;
    }

    protected Element createTemplateElement(Document doc, int bindingStyle) {
        Element element = super.createTemplateElement(doc, bindingStyle);
        if (this.m_children != null && this.m_children.size() > 0) {
            Object obj = null;
            for (int i = 0; i < this.m_children.size(); ++i) {
                obj = this.m_children.get(i);
                if (obj == null || !(obj instanceof WSParam)) continue;
                element.appendChild(((WSParam)obj).createTemplateElement(doc, bindingStyle));
            }
        }
        return element;
    }

    protected void addTemplateElement(Document doc, Element pElement, int bindingStyle) {
        Element element = null;
        element = super.createTemplateElement(doc, bindingStyle);
        if (this.m_children != null && this.m_children.size() > 0) {
            Object obj = null;
            for (int i = 0; i < this.m_children.size(); ++i) {
                obj = this.m_children.get(i);
                if (obj == null || !(obj instanceof WSParam)) continue;
                ((WSParam)obj).addTemplateElement(doc, element, bindingStyle);
            }
        }
        if (element != null && this.isBaseType() && (element.getChildNodes() == null || element.getChildNodes().getLength() == 0)) {
            if (bindingStyle == 2) {
                String value = null;
                value = this.m_typeNSPrefix != null ? this.m_typeNSPrefix + ":" + this.m_typeName : this.m_typeName;
                String aValue = pElement.getAttribute("xsi:type");
                if (aValue != null && aValue.length() > 0 && aValue.compareTo(value) != 0) {
                    element.setAttribute("xsi:type", value);
                }
            }
            element.appendChild(doc.createTextNode(WSTemplateBase.encodeTypeName(this.getTypeName())));
            if (pElement != null) {
                pElement.appendChild(element);
            }
        }
        if (pElement != null && element != null) {
            pElement.appendChild(element);
        }
    }

    public String toString() {
        String s = new String("******** parent *******\n");
        s = s + super.toString();
        if (this.m_children != null && this.m_children.size() > 0) {
            s = s + "Childern count: " + this.m_children.size() + "\nChildren: \n";
            Object obj = null;
            for (int i = 0; i < this.m_children.size(); ++i) {
                obj = this.m_children.get(i);
                if (obj == null || !(obj instanceof WSParam)) continue;
                s = s + "Child[" + i + "] - \n";
                s = s + ((WSParam)obj).toString();
            }
        } else {
            s = s + "Childern count: 0\n";
        }
        s = s + "******** end of " + this.getName() + "\n\n";
        return s;
    }

    protected Vector getFlatParamList() {
        Vector<WSParamParent> list = new Vector<WSParamParent>();
        Vector subList = null;
        list.add(this);
        if (this.m_children != null && this.m_children.size() > 0) {
            Vector children = this.m_children;
            Object obj = null;
            for (int i = 0; i < children.size(); ++i) {
                obj = children.elementAt(i);
                if (obj == null || !(obj instanceof WSParam) || obj instanceof WSParamArray || (subList = ((WSParam)obj).getFlatParamList()) == null) continue;
                list.addAll(subList);
            }
            Object var3_3 = null;
        }
        return list;
    }

    protected void populate(Node node) {
        if (node != null) {
            NodeList childNodes = node.getChildNodes();
            Object obj = null;
            for (int i = 0; i < this.m_children.size(); ++i) {
                Node[] nodes;
                obj = this.m_children.get(i);
                if (obj == null || !(obj instanceof WSParam) || (nodes = WSParam.findNodes(childNodes, ((WSParam)obj).getName())) == null || nodes.length <= 0 || nodes[0] == null) continue;
                if (obj instanceof WSParamArray) {
                    for (int j = 0; j < nodes.length; ++j) {
                        ((WSParam)obj).populate(nodes[j]);
                    }
                    continue;
                }
                if (nodes[0] == null) continue;
                ((WSParam)obj).populate(nodes[0]);
            }
        }
    }

    protected void reset() {
        if (this.m_children != null && this.m_children.size() > 0) {
            Object obj = null;
            for (int i = 0; i < this.m_children.size(); ++i) {
                obj = this.m_children.get(i);
                if (obj == null || !(obj instanceof WSParam)) continue;
                ((WSParam)obj).reset();
            }
        }
    }

    protected void removeAll() {
        if (this.m_children != null && this.m_children.size() > 0) {
            Object obj = null;
            for (int i = 0; i < this.m_children.size(); ++i) {
                obj = this.m_children.get(i);
                if (obj == null || !(obj instanceof WSParam)) continue;
                ((WSParam)obj).removeAll();
            }
            this.m_children.removeAllElements();
            this.m_children = null;
        }
    }

    protected WSParam clone(WSParamParent parent) {
        WSParamParent clone = new WSParamParent(parent, this.getName(), this.getNamespace(), this.getTypeNamespacePrefix(), this.getTypeName());
        this.copyTo(clone);
        return clone;
    }

    protected void copyTo(WSParamParent to) {
        super.copyTo(to);
        if (this.m_children != null) {
            Object obj = null;
            Object param = null;
            for (int i = 0; i < this.m_children.size(); ++i) {
                obj = this.m_children.elementAt(i);
                if (obj == null || !(obj instanceof WSParam)) continue;
                to.addChild(((WSParam)obj).clone(this));
            }
        }
    }
}

